![gist logo](./gist-logo.png)

# About gist

gist is Semantic Arts' minimalist upper ontology for the enterprise. It is designed to have the maximum coverage of typical business ontology concepts with the fewest number of primitives and the least amount of ambiguity.

We maintain an active gist community forum where developers and users of gist come together to discuss the gist model, implementation best practices, and the evolution of gist. Meetings occur virtually on the first Thursday of every other month, starting in January. Please send email to [GistForum@semanticarts.com](mailto:GistForum@semanticarts.com) if you would like to become involved.

You can also contribute to gist by adding your comments to [issue discussion threads](https://github.com/semanticarts/gist/issues) and submitting new issues and pull requests (see [guidelines for contributions](https://github.com/semanticarts/gist/blob/master/docs/Contributing.md)). You can view [minutes](https://github.com/semanticarts/gist/wiki/gist-Development-Team-Meeting-Notes) from our bi-monthly review sessions to find out what we've been discussing and get a preview of upcoming changes to gist.

gist is free and open to the public under the [Creative Commons Attribution 4.0 International](https://creativecommons.org/licenses/by/4.0/) license. In addition to the conditions of this license, we require that any concepts used from gist remain in the gist namespace, and that you do not define your own term definitions in the gist namespace.

[Download the latest version of gist](https://w3id.org/semanticarts/ontology/gistCore).

For more information on gist and to download previous versions, see the [Semantic Arts website](https://www.semanticarts.com/gist).

## Documentation

We provide a number of resources for learning more about gist.

### The gist-doc Repository

Extensive documentation of gist is available in the [gist-doc repository](https://github.com/semanticarts/gist-doc). This repository contains documentation of the [Semantic Arts gist minimalist upper ontology](https://github.com/semanticarts/gist/tree/master) in three formats: narrative, graphical, and Widoco-style.

* **gist Constellations (eBook)**
  * The organization of the eBook is based around the idea of 'constellations' of classes and predicates that deal with related concepts.  
  * epub and mobi formats
* **gist Constellations (visualizations)**
  * A collection of PNG images built using the [Turtle Editor Viewer](http://semantechs.co.uk/turtle-editor-viewer/).  Each image is made up of a single 'constellation' of classes as described above and shows the classes and their relationships, the literal annotations, and any anonymous classes used in class definitions.
* **[Widoco](https://github.com/dgarijo/Widoco) documentation**
  
### Additional Documentation

* **Videos:** We maintain a library of videos containing gist tutorials and recordings of our monthly gist Council meetings. You can find links to these videos on the [Semantic Arts website](https://www.semanticarts.com/gist/videos/), or directly access the entire catalog on [our YouTube channel](https://www.youtube.com/playlist?list=PLk2kJrehubb4dc3e5Db5Lvv9WMaOhV3V7).
* The [Semantic Arts gist web page](https://www.semanticarts.com/gist/).
